/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierSerializer;
import dev.toma.gunsrpg.api.common.attribute.IValueFormatter;
import dev.toma.gunsrpg.common.attribute.NamedModifierWrapper;
import dev.toma.gunsrpg.common.attribute.serialization.ModifierSerialization;
import java.util.UUID;

public class AttributeModifier
implements IAttributeModifier {
    private final UUID uid;
    private final IModifierOp op;
    private final double value;

    public AttributeModifier(String uid, IModifierOp op, double value) {
        this(UUID.fromString(uid), op, value);
    }

    public AttributeModifier(UUID uid, IModifierOp op, double value) {
        this.uid = uid;
        this.op = op;
        this.value = value;
    }

    public NamedModifierWrapper named(String tag) {
        return this.named(tag, IValueFormatter.IDENTITY);
    }

    public NamedModifierWrapper named(String tag, IValueFormatter formatter) {
        return new NamedModifierWrapper(this, formatter, tag);
    }

    @Override
    public UUID getUid() {
        return this.uid;
    }

    @Override
    public IModifierOp getOperation() {
        return this.op;
    }

    @Override
    public double getModifierValue() {
        return this.value;
    }

    @Override
    public IAttributeModifier instance() {
        return this;
    }

    @Override
    public IModifierSerializer<?> getSerializer() {
        return ModifierSerialization.DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeModifier that = (AttributeModifier)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        return "Type: static_modifier, UUID: " + this.uid + ", value: " + this.value + ", op: " + this.op;
    }
}

